unit Service;
//------------------------------------------------------------------------------
//  File name:      Service.pas
//  Last updated:   11/9/03
//  Author:         Sergey Mishkovskiy
//  Company:        USysWare, Inc.
//  Contact info:   usysware@comcast.net
//
//  Compatibility:  Borland Delphi for .NET
//
//  Description:    Consists of TWindowsService class that implements base 
//                  .NET service class.
//------------------------------------------------------------------------------

interface

uses
  System.ServiceProcess;

type
  TWindowsService = class(System.ServiceProcess.ServiceBase)
  strict protected
    procedure OnStart(args: array of string); override;
    procedure OnPause; override;
    procedure OnStop; override;
    procedure OnContinue; override;
    procedure OnShutdown; override;
  public
    constructor Create;
  end;

var
  WindowsService: TWindowsService = nil;

implementation

uses
  ProjectInstaller;

{ TWindowsService }

constructor TWindowsService.Create;
begin
  inherited Create;

  ServiceName := DefaultServiceName;

  CanHandlePowerEvent := False;
  CanPauseAndContinue := True;
  CanShutdown := True;
  CanStop := True;

  EventLog.Source := DefaultServiceName;
  EventLog.Log := ''; //ToDo: set your custom log or leave it blank for defaults

  AutoLog := True;
end;

procedure TWindowsService.OnStart(args: array of string);
begin
  inherited;

  //ToDo: add your code here
end;

procedure TWindowsService.OnPause;
begin
  inherited;

  //ToDo: add your code here
end;

procedure TWindowsService.OnStop;
begin
  inherited;

  //ToDo: add your code here
end;

procedure TWindowsService.OnContinue;
begin
  inherited;

  //ToDo: add your code here
end;

procedure TWindowsService.OnShutdown;
begin
  inherited;

  //ToDo: add your code here
end;

end.
